<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Us</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box
        }

        body {
            font-family: 'Inter', 'Segoe UI', sans-serif;
            background: linear-gradient(135deg, #0f0c29, #302b63, #24243e);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px
        }

        .card {
            background: rgba(255, 255, 255, .06);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, .1);
            border-radius: 20px;
            padding: 40px;
            width: 100%;
            max-width: 480px;
            box-shadow: 0 25px 50px rgba(0, 0, 0, .3)
        }

        .logo {
            font-size: 36px;
            margin-bottom: 8px
        }

        h1 {
            color: #fff;
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 4px
        }

        .sub {
            color: rgba(255, 255, 255, .5);
            font-size: 13px;
            margin-bottom: 28px
        }

        .fg {
            margin-bottom: 18px
        }

        label {
            display: block;
            color: rgba(255, 255, 255, .7);
            font-weight: 500;
            margin-bottom: 6px;
            font-size: 13px
        }

        input,
        textarea {
            width: 100%;
            padding: 12px 16px;
            background: rgba(255, 255, 255, .08);
            border: 1px solid rgba(255, 255, 255, .12);
            border-radius: 10px;
            color: #fff;
            font-size: 14px;
            font-family: inherit;
            transition: all .3s;
            outline: none
        }

        input::placeholder,
        textarea::placeholder {
            color: rgba(255, 255, 255, .25)
        }

        input:focus,
        textarea:focus {
            border-color: #667eea;
            background: rgba(255, 255, 255, .12);
            box-shadow: 0 0 0 3px rgba(102, 126, 234, .2)
        }

        textarea {
            height: 120px;
            resize: vertical
        }

        .btn {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: #fff;
            border: none;
            border-radius: 10px;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
            transition: all .3s;
            margin-top: 6px
        }

        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, .4)
        }

        .alert {
            padding: 14px 18px;
            border-radius: 10px;
            margin-bottom: 20px;
            font-size: 13px;
            animation: si .3s
        }

        .ok {
            background: rgba(40, 167, 69, .15);
            color: #69db7c;
            border: 1px solid rgba(40, 167, 69, .2)
        }

        .err {
            background: rgba(220, 53, 69, .15);
            color: #ff8787;
            border: 1px solid rgba(220, 53, 69, .2)
        }

        .et {
            color: #ff8787;
            font-size: 12px;
            margin-top: 4px
        }

        .info {
            text-align: center;
            color: rgba(255, 255, 255, .2);
            font-size: 11px;
            margin-top: 20px
        }

        @keyframes si {
            from {
                opacity: 0;
                transform: translateY(-10px)
            }

            to {
                opacity: 1;
                transform: translateY(0)
            }
        }
    </style>
</head>

<body>
    <div class="card">
        <div class="logo">📧</div>
        <h1>Contact Us</h1>
        <p class="sub">Fill out the form and we'll get back to you.</p>

        @if(session('success'))
            <div class="alert ok">✅ {{ session('success') }}</div>
        @endif
        @if(session('error'))
            <div class="alert err">❌ {{ session('error') }}</div>
        @endif

        <form method="POST" action="{{ route('contact.submit') }}">
            @csrf
            <div class="fg">
                <label>Your Name</label>
                <input type="text" name="name" value="{{ old('name') }}" placeholder="John Doe" required>
                @error('name') <p class="et">{{ $message }}</p> @enderror
            </div>
            <div class="fg">
                <label>Email Address</label>
                <input type="email" name="email" value="{{ old('email') }}" placeholder="john@example.com" required>
                @error('email') <p class="et">{{ $message }}</p> @enderror
            </div>
            <div class="fg">
                <label>Subject</label>
                <input type="text" name="subject" value="{{ old('subject') }}" placeholder="How can we help?" required>
                @error('subject') <p class="et">{{ $message }}</p> @enderror
            </div>
            <div class="fg">
                <label>Message</label>
                <textarea name="message" placeholder="Write your message..." required>{{ old('message') }}</textarea>
                @error('message') <p class="et">{{ $message }}</p> @enderror
            </div>
            <button type="submit" class="btn">Send Message ✉️</button>
        </form>
        <p class="info">Powered by Laravel Mail</p>
    </div>
</body>

</html>