<?php
/**
 * Script to check database connection status using PHP PDO.
 * * Replace the placeholder values with your actual database credentials.
 */

// --- 1. Database Configuration ---
$host = 'localhost';          // Hostname (e.g., 'localhost' or an IP address)
$db   = 'deepgpu_liv'; // Database name
$user = 'deepgpu_liv';       // Database user
$pass = 'Tower@32';   // Database password
$charset = 'utf8mb4';         // Character set

// DSN (Data Source Name) string for MySQL
$dsn = "mysql:host=$host;dbname=$db;charset=$charset";

// PDO options for error handling and fetching data
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION, // Throw exceptions on error
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,       // Fetch results as associative arrays
    PDO::ATTR_EMULATE_PREPARES   => false,                  // Disable emulation for better performance and security
];

// --- 2. Connection Attempt ---
echo "Attempting to connect to the database '{$db}' on host '{$host}'...\n\n";

try {
     // Create a new PDO instance (connect to the database)
    $pdo = new PDO($dsn, $user, $pass, $options);
    
    // If the PDO object is created successfully, the connection is established.
    echo "✅ **SUCCESS:** Database connection established successfully!\n";
    
    // --- 3. Optional: Test a Simple Query ---
    // You can uncomment this section to confirm the connection is fully functional.
    /*
    $stmt = $pdo->query('SELECT 1');
    $result = $stmt->fetchColumn();
    
    if ($result === '1') {
        echo "✅ Query test passed (SELECT 1 returned 1).\n";
    }
    */

} catch (\PDOException $e) {
    // A connection failed, display the error message.
    echo "❌ **FAILURE:** Database connection failed.\n";
    echo "--- Error Details ---\n";
    // Using $e->getMessage() is safer for showing specific errors during development.
    // In a production environment, you should only log the error, not display it publicly.
    echo "Code: " . $e->getCode() . "\n";
    echo "Message: " . $e->getMessage() . "\n";
}

// Ensure the script stops execution after reporting the result
exit;